import 'dart:convert';

import 'package:flutter/cupertino.dart';
import 'package:flutter/foundation.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/helper/string_format_helper.dart';
import 'package:viser_remit/data/model/transection_history/transaction_history_response_model.dart';

import '../../../core/utils/my_strings.dart';
import '../../../view/components/snack_bar/show_custom_snackbar.dart';
import '../../model/global/response_model/response_model.dart';
import '../../repo/transaction_history_repo/transaction_history_repo.dart';

class TransactionController extends GetxController {
  TransactionHistoryRepo transactionHistoryRepo;
  TransactionController({required this.transactionHistoryRepo});

  int currentType = 0;
  int currentRemark = 0;

  TextEditingController transactionController = TextEditingController();
  final FocusNode transactionFocusNode = FocusNode();

  void changeCurrentType(int index) {
    currentType = index;
    update();
  }

  void changeCurrentRemark(int index) {
    currentRemark = index;
    update();
  }

  List<String> type = [MyStrings.all, MyStrings.plus, MyStrings.minus];
  List<String> remark = ['Any', 'Send money out', 'Send money payment'];

  List<Data> transactionDataList = [];
  List<Remarks> remarksList = [];

  bool isLoading = true;

  String selectedType = '';
  String selectedRemark = '';
  String trxNumberTxt = "";

  bool filterSearch = false;

  bool filterLoading = false;

  setFilterSearch(bool value) {
    filterSearch = value;
    update();
  }

  filterData() async {
    trxNumberTxt = transactionController.text;
    selectedType = type[currentType].toLowerCase();
    if (remarksList.isNotEmpty && remarksList.contains(Remarks(remark: MyStrings.all))) {
      selectedRemark = Converter.replaceSpaceWithUnderScore(remarksList[currentRemark].remark.toString().toLowerCase());
    } else {
      selectedRemark = '';
    }

    filterLoading = true;

    update();

    await loadTransactionHistory();

    filterLoading = false;
    update();
  }

  Future<void> loadTransactionHistory() async {
    isLoading = true;
    update();

    try {
      ResponseModel model = await transactionHistoryRepo.getTransactionData(type: selectedType, remark: selectedRemark, searchText: trxNumberTxt);

      if (model.statusCode == 200) {
        transactionDataList.clear();
        remarksList.clear();
        TransactionHistoryResponseModel transactionHistoryResponseModel = TransactionHistoryResponseModel.fromJson(jsonDecode(model.responseJson));
        if (transactionHistoryResponseModel.mainModel?.transactions?.data != null && transactionHistoryResponseModel.mainModel!.transactions!.data!.isNotEmpty) {
          transactionDataList.addAll(transactionHistoryResponseModel.mainModel!.transactions!.data!);
        }

        if (!remarksList.contains(Remarks(remark: MyStrings.all))) {
          remarksList.insert(0, Remarks(remark: MyStrings.all));
        }
        remarksList.addAll(transactionHistoryResponseModel.mainModel!.remarks!);
      } else {
        CustomSnackBar.error(errorList: [model.message]);
      }
    } catch (e) {
      if (kDebugMode) {
        print(e.toString());
      }
    }

    isLoading = false;
    update();
  }

  List<Remarks> getRemarksList() {
    List<Remarks> data = [];
    data = remarksList.where((element) => element.remark.toString() != 'null').toList();
    return data;
  }
}
